#include "PSXIdleHandler.hpp"

namespace NeoPSX
{
	PSXIdleHandler::PSXIdleHandler()
	: mIdleMode(IM_NULL),
	  mDebugger(NULL)
	{ }

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	PSXIdleHandler::~PSXIdleHandler()
	{
		if(mDebugger.get() != NULL)
		{
			if(::IsWindow(mDebugger->m_hWnd)) mDebugger->DestroyWindow();
		}
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	void PSXIdleHandler::SetIdleMode(ushort newMode)
	{
		mIdleMode = newMode;
	}

	ushort PSXIdleHandler::GetIdleMode() const
	{
		return mIdleMode;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	BOOL PSXIdleHandler::OnIdle()
	{
		switch(mIdleMode)
		{
		//---------------------------------------------------------------
		// Perform operations for the idle FSM state.
		//---------------------------------------------------------------
		case IM_NULL:
			{ } break;
		//---------------------------------------------------------------
		// Emulate a single instruction when in this FSM state.
		//---------------------------------------------------------------
		case IM_EMULATE:
			{
				// Execute the next instruction.
				mEmulator.Execute();

				// Update our debug window if it was created.
				if(mDebugger.get() != NULL)
				{
					if(::IsWindow(mDebugger->m_hWnd)) mDebugger->Update();
				}
			} break;
		//---------------------------------------------------------------
		// Break on an unknown FSM state.
		//---------------------------------------------------------------
		default: break;
		}

		//===============================================================
		// Perform cleanup/final calculations and return success.
		//===============================================================
		return TRUE;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	bool PSXIdleHandler::LoadExecutable(char* fileName)
	{
		if(mEmulator.LoadExecutable(EFString(fileName)))
		{
			mIdleMode = IM_EMULATE;
			return true;
		}
		else
		{
			mIdleMode = IM_NULL;
			return false;
		}
	}

	void PSXIdleHandler::DisplayProcessorDebug()
	{
		try
		{
			mDebugger.reset( new PSXProcessorDebugger( mEmulator.GetContext() ) );
			mDebugger->Create();
		} catch(EFException& error) {
			AtlMessageBox(NULL, (LPCTSTR)error.GetDetailedInformation().c_str());
			//ATLASSERT(error.GetExceptionCode() != EFException::EC_FATAL_ERROR);
		}
	}
} // Namespace NeoPSX